<?php
/**
 * Banners Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Banners extends BaseController {

	/**
	 * Constructor CodeIgniter
	 */
	public function __construct() {
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Banners_model');
	}
	
	public function index() {
		$data['content_title'] = 'Banner';

		$get_data = $this->Banners_model->get_data()->result();
		$data['banner_img'] = $get_data;
		$data['msg'] = $this->session->userdata('msg');

		$this->twiggy_display('adm/banners/index', $data);
		$this->session->unset_userdata('msg');
	}
	
	public function save() {
		if(!empty($_FILES['image_name']['name'])){
	    	$ImageCount = count($_FILES['image_name']['name']);

	        for($i = 0; $i < $ImageCount; $i++){
	            $_FILES['file']['name']       = $_FILES['image_name']['name'][$i];
	            $_FILES['file']['type']       = $_FILES['image_name']['type'][$i];
	            $_FILES['file']['tmp_name']   = $_FILES['image_name']['tmp_name'][$i];
	            $_FILES['file']['error']      = $_FILES['image_name']['error'][$i];
	            $_FILES['file']['size']       = $_FILES['image_name']['size'][$i];

	            // File upload configuration
	            $uploadPath = './assets/images/upload_file/banners/';
	            $config['upload_path'] = $uploadPath;
	            $config['allowed_types'] = 'jpg|jpeg|png';

	            // Load and initialize upload library
	            $this->load->library('upload', $config);
	            $this->upload->initialize($config);

	            // Upload file to server
	            if($this->upload->do_upload('file')){
	                $imageData = $this->upload->data();
	                $uploadImgData[$i]['image_name'] = $imageData['file_name'];
	            }
			}
			
			$save = true;
			if(!empty($uploadImgData)){
        		// Insert files data into the database
	            for($i = 0; $i < $ImageCount; $i++){
		            $data_files = array(
						'banner_img_filename' => $uploadImgData[$i]['image_name']
					);

	            	$save = $this->Banners_model->save($data_files);
	        	}
			}else{
				$save = false;
			}
			
			$msg = '';
			if($save){
				$msg = true;
				$this->session->set_userdata('msg', $msg);
			}
			
        	redirect('adm/banners/');
		}
		
	}

	public function delete($id) {
		$delete = $this->Banners_model->delete($id);

		if($delete){
			$this->session->set_flashdata('success_import');
		}

		unlink('assets/images/upload_file/banners/'.$id);

		redirect('adm/banners/');
	}

}

?>
